/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef MX__ACK_H
#define MX__ACK_H

struct mx_endpoint;
struct mx__partner;

void mx__process_partners_to_ack(struct mx_endpoint * ep);
void mx__process_resend_list(struct mx_endpoint * ep);

void mx__queue_liback(struct mx_endpoint * ep, struct mx__partner *partner, int force);
void mx__liback(struct mx_endpoint * ep, struct mx__partner *partner);

/* modify the following line to select the timer method */
#if (MX_OS_LINUX || MX_OS_WINNT) && !defined MX_KERNEL
typedef uint32_t mx_jiffies_t;
#define mx_jiffies(ep) ((ep)->kernel_window->jiffies)
#define mx_jiffies_hz(ep) ((ep)->kernel_window->hz)
#define MX_NEED_KERNEL_WINDOW 1
#else
#include "mx_timing.h"
typedef mx_cycles_t mx_jiffies_t;
#define mx_jiffies(ep) mx_get_cycles()
#define mx_jiffies_hz(ep) mx_cycles_per_second()
#define MX_NEED_KERNEL_WINDOW 0
#endif


#endif /*  MX__ACK_H */
